import React, {Component} from 'react'
import Ionicon from 'react-ionicons'
import Loading from '../../../Loading/Loading'
import ReactTable from 'react-table'
import {Form, Text} from 'react-form'
import {Modal, ModalBody, ModalHeader} from 'reactstrap'
import {withApollo} from 'react-apollo'
import gql from 'graphql-tag'

class MonitoraggioHabitatMetadatiComponent extends Component {

    constructor(props) {
        super(props);
        this.state = {
            columns: [
                {
                    Header: 'Informazione',
                    accessor: "metadato.descrizione"
                },
                {
                    Header: "Valore",
		    Cell: (row) => (
			<Text
			id={row.original.metadato.id}
			field={row.original.metadato.id}
			    className="form-control"
			 />

		    ),
                    accessor: "valore"
                }
            ],
            submittingReport: false,
            editingReport: null,
            showEditModal: false,
            showCreateModal: false,
            formErrors: null
        };

    }

    render() {
        const {
            data,
	    monitoraggioTemp
        } = this.props;

        const {
            columns,
            submittingReport,
            editingReport,
            formErrors
        } = this.state;

        if(data.error) {
            return(
                <div className="text-danger">
                    Errore nella ricezione dei dati
                </div>
            )
        }

        if(data.loading) {
            return (
                <Loading/>
            )
        }

        return (
            <div className="container-fluid">
                <ReactTable
                    loading={data.loading}
                    noDataText={"Nessun metadato Presente"}
                    className="-highlight"
                    data={data.monitoraggioHabitat?data.monitoraggioHabitat.metadati:monitoraggioTemp.metadati}
                    style={{}}
                    defaultPageSize={100}
		    minRows={0}
		    showPagination={false}
                    nextText="Avanti"
                    previousText="Indietro"
                    loadingText="Caricamento in corso..."
                    rowsText="elementi"
                    ofText="di"
                    pageText="Pagina"
                    columns={columns} />

               

               
            </div>
        )
    }
}

const MonitoraggioHabitatMetadati = withApollo(MonitoraggioHabitatMetadatiComponent)

export default MonitoraggioHabitatMetadati
